/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import java.util.EnumSet;
import net.adventurez.entity.nonliving.ThrownRockEntity;
import net.adventurez.entity.nonliving.VoidBulletEntity;
import net.adventurez.init.SoundInit;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class VoidShadeEntity
extends FlyingMob
implements Enemy {
    public VoidShadeEntity(EntityType<? extends FlyingMob> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new VoidShadeMoveControl(this);
        this.f_21364_ = 0;
    }

    public static AttributeSupplier.Builder createVoidShadeAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22278_, 10.0).m_22268_(Attributes.f_22277_, 80.0);
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new LookAtTargetGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new MoveGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new ShootBulletGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source) || source.m_7640_() instanceof ThrownRockEntity) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        }
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public boolean m_147207_(MobEffectInstance effect, Entity entity) {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_7341_(Entity entity) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return false;
    }

    static class VoidShadeMoveControl
    extends MoveControl {
        private final VoidShadeEntity voidShadeEntity;

        public VoidShadeMoveControl(VoidShadeEntity voidShadeEntity) {
            super((Mob)voidShadeEntity);
            this.voidShadeEntity = voidShadeEntity;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vec3d = new Vec3(this.f_24975_ - this.voidShadeEntity.m_20185_(), this.f_24976_ - this.voidShadeEntity.m_20186_(), this.f_24977_ - this.voidShadeEntity.m_20189_());
                vec3d = vec3d.m_82541_();
                this.voidShadeEntity.m_20256_(this.voidShadeEntity.m_20184_().m_82549_(vec3d.m_82490_(0.012)));
                if (this.voidShadeEntity.m_5448_() == null) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
        }
    }

    static class LookAtTargetGoal
    extends Goal {
        private final VoidShadeEntity voidShadeEntity;

        public LookAtTargetGoal(VoidShadeEntity voidShadeEntity) {
            this.voidShadeEntity = voidShadeEntity;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.voidShadeEntity.m_5448_() == null) {
                Vec3 vec3d = this.voidShadeEntity.m_20184_();
                this.voidShadeEntity.m_146922_(-((float)Mth.m_14136_((double)vec3d.f_82479_, (double)vec3d.f_82481_)) * 57.295776f);
                this.voidShadeEntity.f_20883_ = this.voidShadeEntity.m_146908_();
            } else {
                LivingEntity livingEntity = this.voidShadeEntity.m_5448_();
                if (livingEntity.m_20280_((Entity)this.voidShadeEntity) < 4096.0) {
                    double e = livingEntity.m_20185_() - this.voidShadeEntity.m_20185_();
                    double f = livingEntity.m_20189_() - this.voidShadeEntity.m_20189_();
                    this.voidShadeEntity.m_146922_(-((float)Mth.m_14136_((double)e, (double)f)) * 57.295776f);
                    this.voidShadeEntity.f_20883_ = this.voidShadeEntity.m_146908_();
                }
            }
        }
    }

    static class MoveGoal
    extends Goal {
        private final VoidShadeEntity voidShadeEntity;

        public MoveGoal(VoidShadeEntity voidShadeEntity) {
            this.voidShadeEntity = voidShadeEntity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.voidShadeEntity.m_5448_() != null;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            if (this.voidShadeEntity.m_5448_() != null) {
                LivingEntity livingEntity = this.voidShadeEntity.m_5448_();
                this.voidShadeEntity.m_21566_().m_6849_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), 1.0);
            }
        }
    }

    static class ShootBulletGoal
    extends Goal {
        private final VoidShadeEntity voidShadeEntity;
        public int cooldown;

        public ShootBulletGoal(VoidShadeEntity voidShadeEntity) {
            this.voidShadeEntity = voidShadeEntity;
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = this.voidShadeEntity.m_5448_();
            return livingEntity != null && this.voidShadeEntity.m_142582_((Entity)livingEntity);
        }

        public void m_8056_() {
            this.cooldown = 0;
        }

        public void m_8037_() {
            LivingEntity livingEntity = this.voidShadeEntity.m_5448_();
            if ((double)livingEntity.m_20270_((Entity)this.voidShadeEntity) < 12.0) {
                Level world = this.voidShadeEntity.m_9236_();
                ++this.cooldown;
                if (this.cooldown == 20) {
                    ((ServerLevel)world).m_6269_(null, (Entity)this.voidShadeEntity, SoundInit.SHADOW_CAST_EVENT, SoundSource.HOSTILE, 1.0f, 1.0f);
                    Vec3 vec3d = this.voidShadeEntity.m_20252_(1.0f);
                    VoidBulletEntity voidBulletEntity = new VoidBulletEntity(world, (LivingEntity)this.voidShadeEntity, vec3d.f_82479_ + (double)(world.f_46441_.m_188501_() * 0.5f) - 0.25, vec3d.f_82480_, vec3d.f_82481_ + (double)(world.f_46441_.m_188501_() * 0.5f) - 0.25);
                    world.m_7967_((Entity)voidBulletEntity);
                    this.cooldown = -40;
                }
                if ((double)livingEntity.m_20270_((Entity)this.voidShadeEntity) < 1.0) {
                    this.voidShadeEntity.m_7327_((Entity)livingEntity);
                }
            } else if (this.cooldown > 0) {
                --this.cooldown;
            }
        }
    }
}

